/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.colorless;

import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.powers.GainStrengthPower;
import com.megacrit.cardcrawl.powers.StrengthPower;

public class DarkShackles
extends AbstractCard {
    public static final String ID = "Dark Shackles";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Dark Shackles");
    public static final String NAME = DarkShackles.cardStrings.NAME;
    public static final String DESCRIPTION = DarkShackles.cardStrings.DESCRIPTION;
    private static final int STRENGTH_LOSS = 9;
    private static final int POOL = 1;

    public DarkShackles() {
        super(ID, NAME, null, "colorless/skill/darkShackles", 0, DESCRIPTION, AbstractCard.CardType.SKILL, AbstractCard.CardColor.COLORLESS, AbstractCard.CardRarity.UNCOMMON, AbstractCard.CardTarget.ENEMY, 1);
        this.exhaust = true;
        this.magicNumber = this.baseMagicNumber = 9;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(m, p, new StrengthPower(m, -this.magicNumber), -this.magicNumber));
        if (m != null && !m.hasPower("Artifact")) {
            AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(m, p, new GainStrengthPower(m, this.magicNumber), this.magicNumber));
        }
    }

    @Override
    public AbstractCard makeCopy() {
        return new DarkShackles();
    }

    @Override
    public void upgrade() {
    }
}

